
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot representing average monthly passenger numbers in different transportation modes
years = np.array([2017, 2018, 2019, 2020, 2021, 2022])
passengers_air = np.array([1.2, 1.4, 1.6, 1.1, 1.3, 1.5]) * 100 + np.random.normal(0, 5, 6)  # Adding noise
passengers_train = np.array([0.9, 1.0, 1.1, 0.8, 1.0, 1.2]) * 100 + np.random.normal(0, 5, 6)
passengers_bus = np.array([0.7, 0.8, 0.9, 0.6, 0.7, 0.8]) * 100 + np.random.normal(0, 5, 6)
passengers_ship = np.array([0.5, 0.6, 0.7, 0.4, 0.6, 0.7]) * 100 + np.random.normal(0, 5, 6)
benchmark = np.linspace(80, 80, len(years))  # Benchmark line

# Extracted variables
fill_label_passengers_air = "Air"
fill_label_passengers_train = "Train"
fill_label_passengers_bus = "Bus"
fill_label_passengers_ship = "Ship"
plot_label_benchmark = "Industry Average"
title_text = "Average Monthly Passenger Numbers Over Time by Mode of Transportation"
xlabel_text = "Year"
ylabel_text = "Passengers (in thousands)"
legend_title = "Transportation Modes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (30, 170)
xticks_values = years
yticks_values = np.arange(30, 171, 20)
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1)
legend_ncol = 1
# Create the plot with an entertainment-appropriate color scheme
plt.figure(figsize=(10, 6))
plt.fill_between(years, passengers_air, color="#FF6347", alpha=0.3, label=fill_label_passengers_air)
plt.fill_between(years, passengers_train, color="#4682B4", alpha=0.3, label=fill_label_passengers_train)
plt.fill_between(years, passengers_bus, color="#3CB371", alpha=0.3, label=fill_label_passengers_bus)
plt.fill_between(years, passengers_ship, color="#FFA500", alpha=0.3, label=fill_label_passengers_ship)
plt.plot(
    years,
    benchmark,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_56.pdf", bbox_inches="tight")
