

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
user_activity_levels = ["Idle", "Low", "Medium", "High", "Very High"]
signal_strength = np.array([5, 4.5, 3.5, 2.5, 1.5])
data_usage = np.array([1, 2, 3.5, 4.5, 5.5])
latency = np.array([1, 1.5, 2.5, 3.5, 4.5])

# Calculate cumulative values for stacked area chart
cumulative_signal_strength = signal_strength
cumulative_data_usage = cumulative_signal_strength + data_usage
cumulative_latency = cumulative_data_usage + latency

# Positions for the bars on the x-axis
ind = np.arange(len(user_activity_levels))

# Variables for plot configuration
signal_strength_label = "Signal Strength"
data_usage_label = "Data Usage"
latency_label = "Latency"
xlabel_text = "User Activity Level"
ylabel_text = "Communication Metrics"
title_text = "Cumulative Communication Metrics by User Activity Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, len(user_activity_levels)-1)
ylim_values = (0, 15)
yticks_values = np.arange(0, 16, 1)
legend_location = "upper left"
legend_fontsize = 12
legend_frameon = True
legend_shadow = False
legend_facecolor = "#e8f4f8"
legend_ncol = 1
legend_bbox_to_anchor = (1.05, 1)
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

ax.fill_between(
    ind,
    0,
    cumulative_signal_strength,
    label=signal_strength_label,
    color="#1b9e77",
    alpha=0.7,
)
ax.fill_between(
    ind,
    cumulative_signal_strength,
    cumulative_data_usage,
    label=data_usage_label,
    color="#d95f02",
    alpha=0.7,
)
ax.fill_between(
    ind,
    cumulative_data_usage,
    cumulative_latency,
    label=latency_label,
    color="#7570b3",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)

# Labels, Title and Grid
ax.set_xticks(ind)
ax.set_xticklabels(user_activity_levels)
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)
ax.tick_params(axis="both", which="both", color="gray")

# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_60.pdf", bbox_inches="tight")

