
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Ensuring reproducibility
months = [
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
]
sales_product_a = np.array([120, 130, 125, 140, 150, 160, 170, 180, 190, 200, 220, 240])
sales_product_b = np.array([50, 55, 60, 65, 70, 90, 110, 130, 150, 180, 200, 250])

# Calculate cumulative values for stacked area chart
cumulative_product_a = sales_product_a
cumulative_product_b = cumulative_product_a + sales_product_b

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Variables for plot configuration
product_a_label = "Product A Sales (Units)"
product_b_label = "Product B Sales (Units)"
xlabel_text = "Month"
ylabel_text = "Sales (Units)"
title_text = "Monthly Sales Summary of Products A and B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 11)
ylim_values = (0, 600)
yticks_values = list(range(0, 650, 100))
legend_location = "upper left"
legend_fontsize = 10
legend_frameon = True
legend_shadow = False
legend_facecolor = "#f4f4f4"
legend_ncol = 2
legend_bbox_to_anchor = (0.1, 1.0)

# Plot
fig, ax = plt.subplots(figsize=(12, 8))  # Adjusted for better aspect ratio
ax.fill_between(
    months, 0, cumulative_product_a, label=product_a_label, color="#1f77b4", alpha=0.7
)
ax.fill_between(
    months, cumulative_product_a, cumulative_product_b, label=product_b_label, color="#ff7f0e", alpha=0.7
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=18, y=1.02)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_63.pdf", bbox_inches="tight")
