

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(0)  # Ensuring reproducibility
months = [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
]
# Generate new data for renewable energy production
solar_energy = np.array([400, 420, 380, 460, 490, 520, 560, 580, 530, 500, 470, 450])
wind_energy = np.array([300, 350, 320, 380, 450, 480, 500, 530, 510, 490, 470, 440])

# Calculate cumulative values for stacked area chart
cumulative_solar = solar_energy
cumulative_wind = cumulative_solar + wind_energy

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Variables for plot configuration
solar_label = "Solar Energy Production"
wind_label = "Wind Energy Production"
xlabel_text = "Month"
ylabel_text = "Electricity Production (MWh)"
title_text = "Monthly Renewable Energy Production Overview"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 11)
ylim_values = (0, 2000)
yticks_values = list(range(0, 2200, 200))
legend_location = "upper left"
legend_fontsize = 10
legend_frameon = True
legend_shadow = False
legend_facecolor = "#f9f9f9"
legend_ncol = 2
legend_bbox_to_anchor = (0.1, 1.0)
# Plot
fig, ax = plt.subplots(figsize=(12, 8))  # Adjusted for better aspect ratio
ax.fill_between(
    months, 0, cumulative_solar, label=solar_label, color="#008080", alpha=0.7
)
ax.fill_between(
    months,
    cumulative_solar,
    cumulative_wind,
    label=wind_label,
    color="#FF6F61",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=18, y=1.02)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_64.pdf", bbox_inches="tight")
