
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Set the seed for reproducibility
import numpy as np

np.random.seed(22)

# Data
years = np.arange(2010, 2020)
search_engine_popularity = np.random.uniform(low=50, high=100, size=len(years))
social_media_popularity = np.random.uniform(low=30, high=90, size=len(years))
ecommerce_popularity = np.random.uniform(low=20, high=80, size=len(years))

# Variables for plot configuration
search_engine_label = "Search Engine Popularity"
social_media_label = "Social Media Popularity"
ecommerce_label = "E-commerce Popularity"
xlabel_text = "Years"
ylabel_text = "Popularity Metrics"
title_text = "Tech Industry Popularity Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_values = (0, 250)
xticks_values = years
yticks_values = [0, 50, 100, 150, 200, 250]
legend_location = "upper left"
legend_fontsize = 12

# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

# Stack the data
stack_data = np.vstack((search_engine_popularity, social_media_popularity, ecommerce_popularity))

# Colors for each stack
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Area plot
ax.stackplot(
    years,
    stack_data,
    labels=[search_engine_label, social_media_label, ecommerce_label],
    colors=colors,
    alpha=0.8,
)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Setting the x-axis and y-axis limits and ticks
ax.set_ylim(*ylim_values)
ax.set_xticks(xticks_values)
ax.set_yticks(yticks_values)

# Adding labels and title
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)

# Custom legend
ax.legend(loc=legend_location, fontsize=legend_fontsize, frameon=False)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_66.pdf", bbox_inches="tight")
