

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Set the seed for reproducibility
import numpy as np

np.random.seed(1)

# Data
years = np.arange(2010, 2020)
revenue = np.random.uniform(low=5000, high=15000, size=len(years))  # in $1000s
rnd_spending = np.random.uniform(low=1000, high=3000, size=len(years))  # in $1000s
marketing_spending = np.random.uniform(low=1500, high=4000, size=len(years))  # in $1000s

# Variables for plot configuration
revenue_label = "Revenue ($1000s)"
rnd_label = "R&D Spending ($1000s)"
marketing_label = "Marketing Spending ($1000s)"
xlabel_text = "Years"
ylabel_text = "Financial Metrics"
title_text = "Tech Company Financial Trends Over Years"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_values = (0, 20000)
xticks_values = years
yticks_values = np.arange(0, 21000, 2500)
legend_location = "upper left"
legend_fontsize = 12
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

# Stack the data
stack_data = np.vstack((revenue, rnd_spending, marketing_spending))

# Colors for each stack
colors = ["#8B4513", "#4682B4", "#32CD32"]

# Area plot
ax.stackplot(
    years,
    stack_data,
    labels=[revenue_label, rnd_label, marketing_label],
    colors=colors,
    alpha=0.7,
)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Setting the x-axis and y-axis limits and ticks
ax.set_ylim(*ylim_values)
ax.set_xticks(xticks_values)
ax.set_yticks(yticks_values)

# Adding labels and title
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)

# Custom legend
ax.legend(loc=legend_location, fontsize=legend_fontsize, frameon=False)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_67.pdf", bbox_inches="tight")

