
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
months = np.arange(1, 13)
enrollment_data = {
    "Science": np.random.uniform(250, 400, size=12),
    "Arts": np.random.uniform(200, 350, size=12),
    "Commerce": np.random.uniform(150, 300, size=12),
    "Engineering": np.random.uniform(100, 250, size=12),
    "Medical": np.random.uniform(50, 200, size=12),
}

# Extracted variables
legend_labels = list(enrollment_data.keys())
xlabel_value = "Month"
ylabel_value = "Number of Enrollments"
title_value = "Monthly Enrollment Trends in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 12)
ylim_values = (0, 1200)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#FFD700", "#FF6347", "#8A2BE2", "#3CB371", "#1E90FF"]

fig, ax = plt.subplots(figsize=(12, 8))
ax.stackplot(
    months,
    enrollment_data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)
ax.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_69.pdf", bbox_inches="tight")
