

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
quarters = np.arange(1, 5)
revenue_data = {
    "Company A": np.random.uniform(100, 500, size=4),
    "Company B": np.random.uniform(80, 400, size=4),
    "Company C": np.random.uniform(60, 350, size=4),
    "Company D": np.random.uniform(50, 300, size=4),
    "Company E": np.random.uniform(30, 250, size=4),
}

# Extracted variables
legend_labels = list(revenue_data.keys())
xlabel_value = "Quarter"
ylabel_value = "Revenue in Millions"
title_value = "Quarterly Revenue for Different Companies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 4)
ylim_values = (0, 2000)
legend_loc = "upper left"
legend_reverse = True
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#ff6666", "#ffcc66", "#66ff66", "#66ccff", "#cc99ff"]
fig, ax = plt.subplots(figsize=(12, 8))
ax.stackplot(
    quarters,
    revenue_data.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_71.pdf", bbox_inches="tight")

