
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
year = [2000, 2005, 2010, 2015, 2020, 2025, 2030]
passengers_by_transportation = {
    "Cars": [0.5, 0.6, 0.8, 1.0, 1.3, 1.6, 1.9],
    "Buses": [0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5],
    "Trains": [0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6],
    "Planes": [0.1, 0.12, 0.14, 0.16, 0.18, 0.2, 0.22],
    "Bikes": [0.05, 0.08, 0.1, 0.12, 0.15, 0.18, 0.2],
}

# Extracted variables
legend_labels = list(passengers_by_transportation.keys())
xlabel_value = "Year"
ylabel_value = "Passengers (Billions)"
title_value = "Global Passenger Transportation Growth"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (2000, 2030)
ylim_values = (0, 3.5)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1.1)
title_y_position = 1.05
colors = ["#92c7a3", "#66b2b2", "#ffcc99", "#ff9999", "#c2c2f0"]

fig, ax = plt.subplots(figsize=(10, 7))
ax.stackplot(
    year,
    passengers_by_transportation.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_74.pdf", bbox_inches="tight")
