

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar chart
cities = ["City A", "City B", "City C", "City D", "City E", "City F", "City G", "City H", "City I", "City J"]
num_galleries = [5, 12, 7, 3, 9, 14, 10, 4, 8, 6]
xlabel = "Cities"
ylabel = "Number of Art Galleries"
chart_title = "Number of Art Galleries in Different Cities"
annot_text_high = "Most Galleries"
annot_text_low = "Fewest Galleries"
legend_label = "Avg Number of Galleries"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (0.0, 15.0)
yticks = np.arange(0, 16, 3)

# Create the bar chart
plt.figure(figsize=(12, 8))  # Adjusting figure size for better readability
bars = plt.bar(cities, num_galleries, color=plt.cm.coolwarm(np.linspace(0, 1, len(cities))))

# Highlight the highest and lowest bars
highest_galleries = max(num_galleries)
lowest_galleries = min(num_galleries)
highest_idx = num_galleries.index(highest_galleries)
lowest_idx = num_galleries.index(lowest_galleries)

bars[highest_idx].set_color('red')
bars[lowest_idx].set_color('blue')

# Add a horizontal line for the average number of galleries
average_galleries = np.mean(num_galleries)
plt.axhline(y=average_galleries, color="green", linestyle="--", label=legend_label)

# Add annotations for highest and lowest number of galleries
plt.text(highest_idx, highest_galleries + 0.5, annot_text_high, ha='center', color='red')
plt.text(lowest_idx, lowest_galleries + 0.5, annot_text_low, ha='center', color='blue')

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(chart_title)

# Set y-axis limits and grid lines
plt.ylim(ylim)
plt.yticks(yticks)
plt.grid(axis='y', linestyle='--', alpha=0.7)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_103.pdf", bbox_inches="tight")

