
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the bar chart
companies = range(1, 11)  # Top-10 Tech Companies
market_shares = [14.3, 18.6, 22.1, 11.5, 9.8, 7.2, 5.4, 4.3, 3.9, 3.1]  # Market share percentages
xlabel = "Top-10 Tech Companies"
ylabel = "Market Share (%)"
title = "Market Share of Top-10 Tech Companies"
legend_label = "Average Market Share"

# Calculate the average market share
average_market_share = sum(market_shares) / len(market_shares)

ylim = (0, 25)
yticks = np.arange(0, 26, 2.5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the bar chart
plt.figure(figsize=(10, 6))  # Adjusting figure size to match the original image's dimensions
bars = plt.bar(companies, market_shares, color=["#8b5a2b", "#bc8f8f", "#8fbc8f", "#7cfc00", "#d2691e", "#f4a460", "#556b2f", "#a0522d", "#6b8e23", "#2e8b57"], edgecolor="black", hatch='//')

# Add a horizontal line for the average market share
plt.axhline(y=average_market_share, color="red", linestyle="--", linewidth=2, label=legend_label)

# Add labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Set y-axis limits
plt.ylim(ylim)
# Set x-axis, y-axis ticks
plt.xticks(companies, fontsize=10)
plt.yticks(yticks, fontsize=10)

# Add a legend
plt.legend()

# Add grid lines
plt.grid(True, color='grey', linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_104.pdf", bbox_inches="tight")
