

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for Philosophical Ideology Popularity Rates
popularity_categories = ["Rationalism", "Empiricism", "Existentialism", "Pragmatism", "Total"]
popularity_manual_survey = [65, 70, 55, 60, 62]
popularity_online_survey = [70, 75, 50, 65, 65]
popularity_expert_analysis = [75, 80, 65, 70, 73]
popularity_peer_review = [80, 85, 60, 75, 75]

# Data for Agreement with Philosophical Methods
method_categories = ["Deduction", "Induction", "Skepticism", "Pragmatic Approach", "Total"]
method_manual_survey = [60, 55, 50, 65, 58]
method_online_survey = [65, 60, 55, 70, 63]
method_expert_analysis = [70, 65, 60, 75, 68]
method_peer_review = [75, 70, 65, 80, 73]

# Labels
labels = ["Manual Survey", "Online Survey", "Expert Analysis", "Peer Review"]
title = "Popularity/Agreement Rate (%)"
title1 = "Philosophical Ideology Popularity Rates"
title2 = "Agreement with Philosophical Methods"

# Plot configuration
ylim1 = [0, 100]
yticks1 = np.arange(0, 101, 20)
ylim2 = [0, 100]
yticks2 = np.arange(0, 101, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and axes
fig, axs = plt.subplots(2, 1, figsize=(10, 7))  # Width, Height in inches

# Custom colors
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot for Philosophical Ideology Popularity Rates
x = np.arange(len(popularity_categories))
width = 0.18  # Adjust this value to change the width of the bars
spacing = 0.2  # Adjust this value to change the spacing between the bars

axs[0].bar(x - spacing * 1.5, popularity_manual_survey, width, label=labels[0], color=colors[0])
axs[0].bar(x - spacing / 2, popularity_online_survey, width, label=labels[1], color=colors[1])
axs[0].bar(x + spacing / 2, popularity_expert_analysis, width, label=labels[2], color=colors[2])
axs[0].bar(x + spacing * 1.5, popularity_peer_review, width, label=labels[3], color=colors[3])
axs[0].set_title(title1)
axs[0].set_xticks(x)
axs[0].set_xticklabels(popularity_categories)
axs[0].set_ylim(ylim1)
axs[0].set_yticks(yticks1)
axs[0].legend(loc="upper right", ncol=2)

# Plot for Agreement with Philosophical Methods
x = np.arange(len(method_categories))
axs[1].bar(x - spacing * 1.5, method_manual_survey, width, color=colors[0])
axs[1].bar(x - spacing / 2, method_online_survey, width, color=colors[1])
axs[1].bar(x + spacing / 2, method_expert_analysis, width, color=colors[2])
axs[1].bar(x + spacing * 1.5, method_peer_review, width, color=colors[3])
axs[1].set_title(title2)
axs[1].set_xticks(x)
axs[1].set_xticklabels(method_categories)
axs[1].set_ylim(ylim2)
axs[1].set_yticks(yticks2)

# Add a common y-axis label
fig.text(0.0001, 0.5, title, va="center", rotation="vertical", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_107.pdf", bbox_inches="tight")
