

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
products = [
    "Product A",
    "Product B",
    "Product C",
    "Product D",
    "Product E",
    "Product F",
    "Product G",
    "Product H",
    "Product I",
    "Product J"
]
sales_units = [90, 75, 85, 120, 95, 60, 110, 80, 100, 70]

# Plot labels and titles
ylabel = "Sales (in Units)"
xlabel = "Products"
title = "Sales Performance by Product"
legend_label = "Sales"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (0, 150)
yticks = range(0, 151, 25)
xticks = products  # Assuming xticks are the same as products
xtickslabel_rotation = 45  # Rotate x-axis labels for readability

# Colors
bar_colors = "#1f77b4"

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Width, Height in inches

# Bar chart with customizations
bars = ax.bar(products, sales_units, color=bar_colors, edgecolor='black', alpha=0.7)

# Set labels and title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="x", rotation=xtickslabel_rotation)

# Add gridlines for better readability
ax.yaxis.grid(True)
ax.xaxis.grid(False)

# Hide the border
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Add annotation labels on the bars
for bar in bars:
    height = bar.get_height()
    ax.annotate(f'{height}', xy=(bar.get_x() + bar.get_width() / 2, height),
                xytext=(0, 3),  # 3 points vertical offset
                textcoords="offset points",
                ha='center', va='bottom')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_109.pdf", bbox_inches="tight")
