
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "North America",
    "South America",
    "Europe",
    "Asia",
    "Africa",
    "Australia",
    "Antarctica",
    "Middle East",
    "Caribbean",
    "Central America",
]
values = np.random.randint(500000, 2000000, size=len(categories))  # Generate random values between 500,000 and 2,000,000

# Plot labels and titles
ylabel = "Number of Visitors"
xlabel = "Regions"
title = "Tourist Visits to Different Regions in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = (400000, 2100000)
yticks = np.arange(0, 2100001, 250000)  # Generate yticks from 0 to 2,100,000 with a step of 250,000
xticks = categories
xtickslabel_rotation = 45  # Rotate x-axis labels by 45 degrees for better readability

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Width, Height in inches

# Bar chart with different colors for each bar
colors = plt.cm.viridis(np.linspace(0, 1, len(categories)))  # Use a colormap for distinct colors
bars = ax.bar(categories, values, color=colors)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Set y-axis limit
ax.set_yticks(yticks)
ax.set_title(title)
ax.tick_params(axis="both", which="both", length=0)
# Rotate x-axis labels
plt.xticks(ticks=xticks, rotation=xtickslabel_rotation, ha="right")

# Hide the border
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Add grid for better readability
ax.yaxis.grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_110.pdf", bbox_inches="tight")
