

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = ["Transportation", "Industry", "Residential", "Commercial", "Agriculture"]
values = [0.25, -0.10, 0.05, -0.15, 0.20]

# Plot configuration variables
ylabel = "Percentage Change in CO2 Emissions"
xlabel = "Sectors"
title = "CO2 Emissions Change by Sector (2021-2022)"

xlim = (-0.5, 4.5)
ylim = (-0.2, 0.3)
yticks = [-0.20, -0.15, -0.10, -0.05, 0, 0.05, 0.10, 0.15, 0.20, 0.25, 0.30]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the bar chart
fig, ax = plt.subplots(figsize=(8, 6))
bars = ax.bar(categories, values, color=["#2b83ba", "#abdda4", "#fdae61", "#d7191c", "#6a51a3"], edgecolor="white", width=0.8, zorder=3)

# Set labels and title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.tick_params(axis="y", which="both", length=0)
ax.tick_params(axis="x", which="both", length=0)
ax.set_yticks(yticks)
ax.set_facecolor("#f0f0f5")  # Set the axes background color
ax.yaxis.grid(True, color="white", zorder=2)  # Add grid lines

# Remove the border around the chart area
for spine in ax.spines.values():
    spine.set_visible(False)

# Ensure that the bars for negative values start from zero
for bar in bars:
    if bar.get_height() < 0:
        bar.set_y(0)

# Add padding around the chart
plt.subplots_adjust(left=0.15, right=0.95, top=0.9, bottom=0.15)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("bar_112.pdf", bbox_inches="tight")

