

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = ["North America", "Europe", "Asia", "South America", "Africa", "Australia", "Middle East"]
values = [-3.5, 7.8, 15.2, -2.5, -2.3, 8.1, 5.4]

# Plot configuration variables
ylabel = "Sales Growth (%)"
xlabel = "Regions"
title = "Sales Growth Across Regions for Product X"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (-0.5, len(categories) - 0.5)
ylim = (-5, 20)
yticks = [-5, 0, 5, 10, 15, 20]

# Create the figure and the bar chart
fig, ax = plt.subplots(figsize=(8, 6))
bars = ax.bar(categories, values, color=["#2c7fb8", "#7fcdbb", "#41b6c4", "#1d91c0", "#253494", "#225ea8", "#0c2c84"], edgecolor="white", width=0.8, zorder=3)

# Set labels and title
ax.set_title(title, fontsize=14, pad=15)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.set_facecolor("#f5f5f5")  # Set the axes background color to light gray

# Customize the ticks and grid lines
ax.tick_params(axis="y", which="both", length=0, labelsize=10)
ax.tick_params(axis="x", which="both", length=0, labelsize=10)
ax.yaxis.grid(True, color="white", zorder=2)

# Remove the border around the chart area
for spine in ax.spines.values():
    spine.set_visible(False)

# Ensure that the bars for negative values start from zero
for bar in bars:
    if bar.get_height() < 0:
        bar.set_y(0)

# Add padding around the chart
plt.subplots_adjust(left=0.15, right=0.95, top=0.90, bottom=0.15)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("bar_113.pdf", bbox_inches="tight")

