
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots
cities = ["City A", "City B", "City C", "City D", "City E"]
north_america_aqi = [45, 67, 85, 120, 130]
europe_aqi = [55, 65, 75, 90, 100]
asia_aqi = [90, 110, 150, 180, 200]

title1 = "North America Air Quality Index (AQI)"
axvline1 = 0
title2 = "Europe Air Quality Index (AQI)"
axvline2 = 0
title3 = "Asia Air Quality Index (AQI)"
axvline3 = 0

xlabel = "AQI"
supertitle = "Air Quality Index Across Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [
    np.arange(0, 151, 30),    # North America
    np.arange(0, 121, 20),    # Europe
    np.arange(0, 201, 40)     # Asia
]

# Set the figure size to enhance readability and appearance
fig, axes = plt.subplots(1, 3, figsize=(12, 6))

# Define colors for each region
colors = ["#1f77b4", "#2ca02c", "#ff7f0e"]  # Blue, Green, Orange

# Plot for North America
axes[0].barh(cities, north_america_aqi, color=colors[0])
axes[0].set_title(title1)
for i, v in enumerate(north_america_aqi):
    axes[0].text(
        v + 0.5, i, f"{v}", color="black", va="center", ha="left"
    )
axes[0].axvline(axvline1, color="black")

# Plot for Europe
axes[1].barh(cities, europe_aqi, color=colors[1])
axes[1].set_title(title2)
for i, v in enumerate(europe_aqi):
    axes[1].text(
        v + 0.5, i, f"{v}", color="black", va="center", ha="left"
    )
axes[1].axvline(axvline2, color="black")

# Plot for Asia
axes[2].barh(cities, asia_aqi, color=colors[2])
axes[2].set_title(title3)
for i, v in enumerate(asia_aqi):
    axes[2].text(
        v + 0.5, i, f"{v}", color="black", va="center", ha="left"
    )
axes[2].axvline(axvline3, color="black")

# Set xticks
axes[0].set_xticks(xticks[0])
axes[1].set_xticks(xticks[1])
axes[2].set_xticks(xticks[2])

# Hide all axes except the bottom one
for ax in axes:
    for spine in ["left", "right", "top"]:
        ax.spines[spine].set_visible(False)

# Hide y-axis labels for axes[1] and axes[2]
axes[1].set_yticks([])
axes[1].set_yticklabels([])
axes[2].set_yticks([])
axes[2].set_yticklabels([])

# Add x-axis label for all axes
for ax in axes:
    ax.set_xlabel(xlabel)

fig.suptitle(supertitle, fontsize=16)
plt.subplots_adjust(wspace=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_116.pdf", bbox_inches="tight")

