

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
seasons = ["Winter", "Summer", "Winter", "Summer"]
cities = ["New York", "Los Angeles", "Chicago", "Houston"]
temperatures = {
    "New York": [0, 27, -2, 28],
    "Los Angeles": [15, 26, 14, 23],
    "Chicago": [-5, 25, -8, -6],
    "Houston": [10, -4, 9, 36],
}

xlabel = "Season"
ylabel = "Average Temperature [°C]"
legendtitle = "City"
title = "Average Monthly Temperatures in Different Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))
# Colors for each city
colors = ["#4CAF50", "#FFEB3B", "#FF9800", "#795548"]

# Bar width
bar_width = 0.15

# Positions of the bars on the x-axis
r = np.arange(len(seasons))

for i, city in enumerate(cities):
    # Plot bars
    bars = plt.bar(
        r,
        temperatures[city],
        color=colors[i],
        hatch="//",
        width=bar_width,
        edgecolor="white",
        label=city,
    )
    # Add text labels
    for bar, val in zip(bars, temperatures[city]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + (0.5 if val > 0 else -1.5),
            str(val),
            ha="center",
        )

    # Move the position for the next set of bars
    r = [x + bar_width for x in r]

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks([r + bar_width * 2 for r in range(len(seasons))], seasons)

# Add ylabel
plt.ylabel(ylabel)

plt.gca().grid(color="gray", linewidth=0.5)
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, bbox_to_anchor=(0.5, 1), loc="upper center", ncol=3)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_118.pdf", bbox_inches="tight")

