

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
labels = ["Policy A", "Policy B", "Policy C", "Policy D", "Policy E", "Policy F"]
youth_approval = [0.65, 0.70, 0.68, 0.74, 0.72, 0.75]
adults_approval = [0.60, 0.65, 0.63, 0.67, 0.66, 0.70]
seniors_approval = [0.55, 0.58, 0.60, 0.62, 0.65, 0.68]

x = np.arange(len(labels))  # the label locations
width = 0.25  # the width of the bars

# Variables for plot configuration
ylabel = "Approval Rating"
xlabel_policy = "Political Policies"

legend_label_youth = "Youth"
legend_label_adults = "Adults"
legend_label_seniors = "Seniors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = x
xticklabels = labels
ylim_ax1 = (0.50, 0.80)
ylim_ax2 = (0.50, 0.80)
yticks_ax1 = [0.50, 0.55, 0.60, 0.65, 0.70, 0.75, 0.80]
yticks_ax2 = [0.50, 0.55, 0.60, 0.65, 0.70, 0.75, 0.80]

# Setting up the figure and axes for a 2 x 1 layout
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(7, 5), gridspec_kw={"height_ratios": [1, 1], "hspace": 0.3}
)

# Upper plot
rects1 = ax1.bar(
    x - width - 0.04,
    youth_approval,
    width,
    label=legend_label_youth,
    color="#a3c1da",
    edgecolor="black",
)
rects2 = ax1.bar(
    x, adults_approval, width, label=legend_label_adults, color="#b6d7a8", edgecolor="black"
)
rects3 = ax1.bar(
    x + width + 0.04,
    seniors_approval,
    width,
    label=legend_label_seniors,
    color="#d9b3ff",
    edgecolor="black",
)

# Lower plot
rects4 = ax2.bar(
    x - width - 0.04, youth_approval, width, color="#a3c1da", edgecolor="black"
)
rects5 = ax2.bar(x, adults_approval, width, color="#b6d7a8", edgecolor="black")
rects6 = ax2.bar(
    x + width + 0.04, seniors_approval, width, color="#d9b3ff", edgecolor="black"
)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax1.set_ylabel(ylabel)
ax2.set_ylabel(ylabel)
ax1.set_xlabel(xlabel_policy)
ax2.set_xlabel(xlabel_policy)
ax1.set_xticks(xticks)
ax1.set_xticklabels(xticklabels)
ax2.set_xticks(xticks)
ax2.set_xticklabels(xticklabels)
ax1.legend(loc="upper center", bbox_to_anchor=(0.5, 1.25), ncol=3, frameon=False)

# Set y-axis limit to match the reference picture
ax1.set_ylim(ylim_ax1)
ax2.set_ylim(ylim_ax2)
ax1.tick_params(axis="x", which="both", length=0)
ax2.tick_params(axis="x", which="both", length=0)
ax1.set_yticks(yticks_ax1)
ax2.set_yticks(yticks_ax2)

# Set grid color and style
ax1.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax2.grid(axis="y", color="gray", linestyle="--", linewidth=0.5)
ax1.tick_params(axis="y", which="major", color="gray")
ax2.tick_params(axis="y", which="major", color="gray")
ax1.set_axisbelow(True)
ax2.set_axisbelow(True)

# Remove top and right borders
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.spines["bottom"].set_visible(False)
ax1.spines["left"].set_color("gray")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.spines["bottom"].set_visible(False)
ax2.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_120.pdf", bbox_inches="tight")

