
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for Technology domain
companies = ["Company A", "Company B", "Company C", "Company D", "Company E", "Company F"]
articles = {
    "Company A": [15, 30, 20, 25, 10],
    "Company B": [20, 25, 30, 15, 20],
    "Company C": [25, 20, 15, 30, 25],
    "Company D": [30, 15, 25, 20, 30],
    "Company E": [20, 25, 20, 15, 25],
    "Company F": [15, 20, 25, 30, 20],
}

# Variables for plot configuration
title = "Number of Articles Published by Tech Companies in Different Categories"
xlabel = "Companies"
ylabel = "Number of Articles Published"
legend_title = "Categories"
legend_labels = ["AI", "Cloud Computing", "IoT", "Blockchain", "Cybersecurity"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each category
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]

ylim = (0, 100)
yticks = np.arange(0, 101, 10)

legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1.0)
legend_reverse = True

# Plotting the stacked bar chart
fig, ax = plt.subplots(figsize=(10, 6))

for i, company in enumerate(companies):
    bottom = 0
    for j, count in enumerate(articles[company]):
        ax.bar(company, count, bottom=bottom, color=colors[j])
        bottom += count

# Adding title and labels
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="x", which="both", length=0)
ax.tick_params(axis="y", which="both", length=5)

# Adding legend
ax.legend(
    legend_labels,
    title=legend_title,
    frameon=False,
    bbox_to_anchor=legend_bbox_to_anchor,
    loc=legend_loc,
    reverse=legend_reverse,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_123.pdf", bbox_inches="tight")
