

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data: Weekly participation in different types of therapy sessions
weeks = ["Week 1", "Week 2", "Week 3", "Week 4", "Week 5", "Week 6"]
therapy_counts = {
    "Week 1": [35, 25, 15, 10, 25],
    "Week 2": [40, 20, 20, 15, 10],
    "Week 3": [50, 30, 10, 5, 10],
    "Week 4": [45, 25, 20, 10, 5],
    "Week 5": [60, 20, 15, 10, 10],
    "Week 6": [55, 30, 10, 10, 5],
}

# Variables for plot configuration
title = "Weekly Participation in Different Types of Therapy Sessions"
xlabel = "Weeks"
ylabel = "Number of Participants"

legend_title = "Therapy Types"
legend_labels = ["Cognitive", "Behavioral", "Psychodynamic", "Humanistic", "Group"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each therapy type
colors = ["#2a9d8f", "#264653", "#e76f51", "#f4a261", "#e9c46a"]

ylim = (0, 100)
yticks = [0, 25, 50, 75, 100]

legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1.0)
legend_reverse = True

# Plotting the stacked bar chart
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, week in enumerate(weeks):
    bottom = 0
    for j, count in enumerate(therapy_counts[week]):
        ax.bar(week, count, bottom=bottom, color=colors[j])
        bottom += count

# Adding title and labels
ax.set_title(title, fontsize=14)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(
    legend_labels,
    title=legend_title,
    frameon=False,
    bbox_to_anchor=legend_bbox_to_anchor,
    loc=legend_loc,
    reverse=legend_reverse,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_124.pdf", bbox_inches="tight")
