
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for sports and metrics
sports = ["Football", "Basketball", "Tennis", "Cricket", "Swimming", "Baseball"]
scores = {
    "Football": [8, 9, 10, 7, 6],
    "Basketball": [9, 8, 10, 6, 7],
    "Tennis": [7, 6, 11, 8, 8],
    "Cricket": [6, 7, 9, 10, 8],
    "Swimming": [10, 9, 8, 7, 6],
    "Baseball": [9, 8, 7, 9, 7],
}

# Variables for plot configuration
title = "Evaluating Sports on Various Performance Metrics"
xlabel = "Sports"
ylabel = "Scores"
legend_title = "Metrics"
legend_labels = ["Speed", "Strength", "Endurance", "Skill", "Strategy"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each metric
colors = ["#3b6fa1", "#70a1d7", "#80c7e8", "#a1d6e2", "#dee7ec"]

ylim = (0, 40)
yticks = [0, 5, 10, 15, 20, 25, 30, 35, 40]

legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1.1)
legend_reverse = False

# Plotting the stacked bar chart
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjusting figure size to accommodate detailed data and aesthetics

for i, sport in enumerate(sports):
    bottom = 0
    for j, score in enumerate(scores[sport]):
        ax.bar(sport, score, bottom=bottom, color=colors[j], alpha=0.8)
        bottom += score

# Adding title and labels
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)
ax.set_yticks(yticks)
ax.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(
    legend_labels,
    title=legend_title,
    frameon=False,
    bbox_to_anchor=legend_bbox_to_anchor,
    loc=legend_loc,
    reverse=legend_reverse,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_125.pdf", bbox_inches="tight")
