
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plots
ethical_theories = ["Utilitarianism", "Deontology", "Virtue Ethics"]
responses_s1 = np.array([[210, 90, 100], [150, 100, 150], [180, 120, 100]])
responses_s2 = np.array([[200, 80, 120], [130, 120, 150], [170, 70, 160]])

# Variables for plot configuration
xlabel_value = "Number of Students"
ylabel_value = "Ethical Theory"
title_s1 = "Scenario 1: Student Responses to Ethical Theories"
title_s2 = "Scenario 2: Student Responses to Ethical Theories"
legend_labels = ["Approval", "Disapproval", "Neutral"]
fig_title = "Philosophy Students' Responses by Ethical Theory"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for the bars
colors = ["#76c7c0", "#ffb347", "#ffa07a"]
width = 0.3
xlim_value = (0, 400)
xticks_value = [0, 50, 100, 150, 200, 250, 300, 350, 400]
yticks_value = ethical_theories
fontsize_title = 16

# Create subplots with shared x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8), sharex=True)

# Function to plot stacked bars
def plot_stacked_bars(ax, counts, roles, colors):
    bottom = np.zeros(len(roles))
    for i in range(counts.shape[1]):
        ax.barh(
            roles, counts[:, i], height=width, zorder=5, left=bottom, color=colors[i]
        )
        bottom += counts[:, i]

# Plot for Scenario 1
plot_stacked_bars(ax1, responses_s1, ethical_theories, colors)
ax1.set_title(title_s1, y=1.2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value)
ax1.invert_yaxis()  # Invert y-axis to match the picture
ax1.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with dashed lines
ax1.set_xlim(*xlim_value)
ax1.tick_params(axis="y", which="both", length=0)
ax1.tick_params(axis="x", which="both", color="gray")

# Plot for Scenario 2
plot_stacked_bars(ax2, responses_s2, ethical_theories, colors)
ax2.set_title(title_s2)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.set_xlim(*xlim_value)
ax2.invert_yaxis()  # Invert y-axis to match the picture
ax2.grid(True, alpha=0.7, linestyle='--')  # Add grid lines with dashed lines
ax2.tick_params(axis="y", which="both", length=0)
ax2.tick_params(axis="x", which="both", color="gray")

# Legend
ax1.legend(
    legend_labels,
    bbox_to_anchor=(0.5, 1.2),
    loc="upper center",
    ncol=3,
    frameon=False,
)

# Set x-axis ticks after all plots
ax1.set_xticks(xticks_value)
ax2.set_xticks(xticks_value)
ax1.tick_params(axis="x", which="both", bottom=True, top=False, labelbottom=True)

# Title for the whole figure
fig.suptitle(fig_title, fontsize=fontsize_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_127.pdf", bbox_inches="tight")

