
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
modes_of_transport = ["Car", "Bus", "Train", "Bicycle", "Walking"]
Region_A = [40, 22, 15, 10, 13]
Region_B = [35, 25, 20, 8, 12]
Region_C = [30, 30, 18, 15, 7]
Region_D = [45, 20, 10, 12, 13]
Region_E = [38, 27, 17, 8, 10]

# Plot labels
xlabel = "Modes of Transportation"
ylabel = "Usage (%)"
title = "Transportation Mode Usage Across Different Regions"

# Legend labels
Region_A_label = "Region A"
Region_B_label = "Region B"
Region_C_label = "Region C"
Region_D_label = "Region D"
Region_E_label = "Region E"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
barWidth = 0.16
xticks = [r + barWidth * 2 for r in range(len(Region_A))]
xtickslabel = modes_of_transport
yticks = [0, 10, 20, 30, 40, 50]
ytickslabel = None
xlim = None
ylim = (0, 50)

# Set figure size
plt.figure(figsize=(10, 5))

# Set position of bar on X axis
r1 = np.arange(len(Region_A))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Make the plot
plt.bar(
    r1,
    Region_A,
    color="#6a994e",
    width=barWidth,
    edgecolor="white",
    label=Region_A_label,
)
plt.bar(
    r2,
    Region_B,
    color="#4ea8de",
    width=barWidth,
    edgecolor="white",
    label=Region_B_label,
)
plt.bar(
    r3,
    Region_C,
    color="#f77f00",
    width=barWidth,
    edgecolor="white",
    label=Region_C_label,
)
plt.bar(
    r4,
    Region_D,
    color="#9d4edd",
    width=barWidth,
    edgecolor="white",
    label=Region_D_label,
)
plt.bar(
    r5, Region_E, color="#ffb4a2", width=barWidth, edgecolor="white", label=Region_E_label
)

# Add labels
for i in range(len(modes_of_transport)):
    plt.text(
        r1[i],
        Region_A[i] + 1,
        str(Region_A[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r2[i],
        Region_B[i] + 1,
        str(Region_B[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r3[i],
        Region_C[i] + 1,
        str(Region_C[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r4[i],
        Region_D[i] + 1,
        str(Region_D[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r5[i], Region_E[i] + 1, str(Region_E[i]), ha="center", fontsize=8, rotation=45
    )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xtickslabel)

# Create legend & Show graphic
plt.ylabel(ylabel, fontsize=12)
plt.ylim(ylim)
plt.yticks(yticks)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False, ncol=5)

plt.tick_params(axis="x", which="both", length=0)
plt.tick_params(axis="y", color="gray")

# Add y grid
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# Remove top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_129.pdf", bbox_inches="tight")
