

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = ["Criminal Law", "Family Law", "Corporate Law", "Labor Law", "Average"]
LawFirm_A = [150, 200, 250, 180, 195]
LawFirm_B = [170, 190, 230, 210, 200]
LawFirm_C = [160, 205, 240, 215, 205]
LawFirm_D = [180, 195, 220, 200, 200]
LawFirm_E = [175, 210, 225, 190, 200]

# Plot labels
xlabel = "Legal Categories"
ylabel = "Cases Handled"
title = "Number of Cases Handled by Law Firms Across Different Legal Categories"

# Legend labels
LawFirm_A_label = "Law Firm A"
LawFirm_B_label = "Law Firm B"
LawFirm_C_label = "Law Firm C"
LawFirm_D_label = "Law Firm D"
LawFirm_E_label = "Law Firm E"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
barWidth = 0.16
xticks = [r + barWidth * 2 for r in range(len(LawFirm_A))]
xtickslabel = categories
yticks = [100, 150, 200, 250, 300]
ytickslabel = None
xlim = None
ylim = (100, 300)

# Set figure size
plt.figure(figsize=(12, 6))

# Set position of bar on X axis
r1 = np.arange(len(LawFirm_A))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Make the plot
plt.bar(
    r1,
    LawFirm_A,
    color="#4C72B0",
    width=barWidth,
    edgecolor="gray",
    label=LawFirm_A_label,
)
plt.bar(
    r2,
    LawFirm_B,
    color="#55A868",
    width=barWidth,
    edgecolor="gray",
    label=LawFirm_B_label,
)
plt.bar(
    r3,
    LawFirm_C,
    color="#C44E52",
    width=barWidth,
    edgecolor="gray",
    label=LawFirm_C_label,
)
plt.bar(
    r4,
    LawFirm_D,
    color="#8172B3",
    width=barWidth,
    edgecolor="gray",
    label=LawFirm_D_label,
)
plt.bar(
    r5, LawFirm_E, color="#CCB974", width=barWidth, edgecolor="gray", label=LawFirm_E_label
)

# Add labels
for i in range(len(categories)):
    plt.text(
        r1[i],
        LawFirm_A[i] + 5,
        str(LawFirm_A[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r2[i],
        LawFirm_B[i] + 5,
        str(LawFirm_B[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r3[i],
        LawFirm_C[i] + 5,
        str(LawFirm_C[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r4[i],
        LawFirm_D[i] + 5,
        str(LawFirm_D[i]),
        ha="center",
        fontsize=8,
        rotation=45,
    )
    plt.text(
        r5[i], LawFirm_E[i] + 5, str(LawFirm_E[i]), ha="center", fontsize=8, rotation=45
    )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xtickslabel)

# Create legend & Show graphic
plt.ylabel(ylabel, fontsize=12)
plt.ylim(ylim)
plt.yticks(yticks)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False, ncol=5)

# Add y grid
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# Remove top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_130.pdf", bbox_inches="tight")

