

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["Accommodation", "Food", "Transport", "Activities", "Average"]
USA = [75.1, 80.2, 78.3, 70.4, 76.0]
Canada = [78.0, 82.1, 80.5, 72.3, 78.2]
UK = [74.3, 81.0, 77.0, 69.8, 75.5]
Australia = [80.2, 83.5, 79.5, 76.0, 79.8]
Average = [76.9, 81.7, 78.8, 72.1, 77.4]

# Plot labels
xlabel = "Tourism Service Categories"
ylabel = "Average Satisfaction Rating (%)"
title = "Average Satisfaction Ratings of Tourism Services by Country"

# Legend labels
USA_label = "USA"
Canada_label = "Canada"
UK_label = "UK"
Australia_label = "Australia"
Average_label = "Average"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
barWidth = 0.16
xticks = [r + barWidth * 2 for r in range(len(USA))]
xtickslabel = categories
yticks = [60, 65, 70, 75, 80, 85, 90]
ytickslabel = None
xlim = None
ylim = (60, 90)

# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 5))

# Set position of bar on X axis
r1 = np.arange(len(USA))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Make the plot
plt.bar(
    r1,
    USA,
    color="#FF6F61",
    width=barWidth,
    edgecolor="white",
    label=USA_label,
)
plt.bar(
    r2,
    Canada,
    color="#6B5B95",
    width=barWidth,
    edgecolor="white",
    label=Canada_label,
)
plt.bar(
    r3,
    UK,
    color="#88B04B",
    width=barWidth,
    edgecolor="white",
    label=UK_label,
)
plt.bar(
    r4,
    Australia,
    color="#FFA07A",
    width=barWidth,
    edgecolor="white",
    label=Australia_label,
)
plt.bar(
    r5,
    Average,
    color="#0E4D92",
    width=barWidth,
    edgecolor="white",
    label=Average_label,
)

# Add labels
for i in range(len(categories)):
    plt.text(
        r1[i],
        USA[i] + 1,
        str(USA[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r2[i],
        Canada[i] + 1,
        str(Canada[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r3[i],
        UK[i] + 1,
        str(UK[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r4[i],
        Australia[i] + 1,
        str(Australia[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )
    plt.text(
        r5[i],
        Average[i] + 1,
        str(Average[i]),
        ha="center",
        fontsize=6,
        rotation=45,
    )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xtickslabel)

# Create legend & Show graphic
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.ylim(ylim)
plt.yticks(yticks)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False, ncol=5)

plt.tick_params(axis="x", which="both", length=0)
plt.tick_params(axis="y", color="gray")

# Add y grid
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# Remove top and right borders
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_131.pdf", bbox_inches="tight")

