

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
products = ["Product A", "Product B", "Product C"]
q1_sales = [150, 200, 250]
q2_sales = [180, 220, 260]
q3_sales = [210, 240, 270]
q4_sales = [230, 260, 280]
q5_sales = [260, 280, 290]

barWidth = 0.15
r1 = np.arange(len(q1_sales))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Labels
labels = ["Quarter 1", "Quarter 2", "Quarter 3", "Quarter 4", "Quarter 5"]
ylabel = "Sales (in units)"
xlabel = "Products"
title = "Product Sales Across Five Quarters"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [140, 300]
yticks = [150, 200, 250, 300]

# Create figure
plt.figure(figsize=(10, 6))

# Create bars
plt.bar(r1, q1_sales, color="#FF9999", width=barWidth, edgecolor="black", label=labels[0])
plt.bar(r2, q2_sales, color="#66B2FF", width=barWidth, edgecolor="black", label=labels[1])
plt.bar(r3, q3_sales, color="#99FF99", width=barWidth, edgecolor="black", label=labels[2])
plt.bar(r4, q4_sales, color="#FFCC66", width=barWidth, edgecolor="black", label=labels[3])
plt.bar(r5, q5_sales, color="#B266FF", width=barWidth, edgecolor="black", label=labels[4])

# Add xticks on the middle of the group bars
plt.xticks([r + barWidth * 2 for r in range(len(q1_sales))], products)

# Add gridlines for better readability
plt.grid(axis='y', linestyle='--', alpha=0.7)

# Create legend & Show graphic
plt.legend(loc="upper left")
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.ylim(ylim)
plt.yticks(yticks)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_133.pdf", bbox_inches="tight")
