
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # For reproducibility

# Sample data
age_groups = np.linspace(10, 70, 10)
education_levels = np.linspace(0, 10, 6)
regions = np.linspace(0, 5, 6)

# Sample percentage change in religious adherence for 'Active Practitioners' and 'Casual Practitioners'
change_adherence_age_active = np.random.uniform(-10, 10, 10)
change_adherence_education_active = np.random.uniform(-15, 5, 6)
change_adherence_region_active = np.random.uniform(-20, 20, 6)

change_adherence_age_casual = np.random.uniform(-10, 10, 10)
change_adherence_education_casual = np.random.uniform(-15, 5, 6)
change_adherence_region_casual = np.random.uniform(-20, 20, 6)

# Extracted variables
label_active = "Active Practitioners"
label_casual = "Casual Practitioners"
xlabel_age = "Age Groups"
ylabel_adherence_change = "Adherence Change [%]"
xlabel_education = "Education Levels"
xlabel_region = "Geographical Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_age = (-15, 15)
xlim_age = (8, 72)
yticks_age = [-15, -10, -5, 0, 5, 10, 15]
xticks_age = list(range(10, 71, 10))
ylim_education = (-20, 10)
xlim_education = (-1, 11)
yticks_education = [-20, -15, -10, -5, 0, 5, 10]
xticks_education = list(range(0, 11, 2))
ylim_region = (-25, 25)
xlim_region = (-1, 6)
yticks_region = [-25, -20, -15, -10, -5, 0, 5, 10, 15, 20, 25]
xticks_region = list(range(0, 6, 1))

# Create figure and subplots
fig, axs = plt.subplots(3, 1, figsize=(8, 10))

# Top chart - Age Groups
axs[0].bar(
    age_groups - 1,
    change_adherence_age_active,
    width=2,
    zorder=10,
    color="#3cb44b",
    edgecolor="black",
    label=label_active,
    hatch='/'
)
axs[0].bar(
    age_groups + 1,
    change_adherence_age_casual,
    width=2,
    zorder=10,
    color="#ffa600",
    edgecolor="black",
    label=label_casual,
    hatch='\\'
)
axs[0].set_xlabel(xlabel_age)
axs[0].set_ylabel(ylabel_adherence_change)
axs[0].set_ylim(ylim_age)
axs[0].set_xlim(xlim_age)
axs[0].set_yticks(yticks_age)
axs[0].xaxis.set_major_locator(ticker.FixedLocator(xticks_age))
axs[0].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
axs[0].grid(True, which="major", axis="y", color="gray", linestyle='--')
axs[0].tick_params(axis="x", which="major", length=0)

# Middle chart - Education Levels
axs[1].bar(
    education_levels - 0.2,
    change_adherence_education_active,
    width=0.4,
    zorder=10,
    color="#3cb44b",
    edgecolor="black",
    hatch='/'
)
axs[1].bar(
    education_levels + 0.2,
    change_adherence_education_casual,
    width=0.4,
    zorder=10,
    color="#ffa600",
    edgecolor="black",
    hatch='\\'
)
axs[1].set_xlabel(xlabel_education)
axs[1].set_ylabel(ylabel_adherence_change)
axs[1].set_ylim(ylim_education)
axs[1].set_xlim(xlim_education)
axs[1].set_yticks(yticks_education)
axs[1].xaxis.set_major_locator(ticker.FixedLocator(xticks_education))
axs[1].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
axs[1].grid(True, which="major", axis="y", color="gray", linestyle='--')
axs[1].tick_params(axis="x", which="major", length=0)

# Bottom chart - Geographical Regions
axs[2].bar(
    regions - 0.25,
    change_adherence_region_active,
    width=0.5,
    zorder=10,
    color="#3cb44b",
    edgecolor="black",
    hatch='/'
)
axs[2].bar(
    regions + 0.25,
    change_adherence_region_casual,
    width=0.5,
    zorder=10,
    color="#ffa600",
    edgecolor="black",
    hatch='\\'
)
axs[2].set_xlabel(xlabel_region)
axs[2].set_ylabel(ylabel_adherence_change)
axs[2].set_ylim(ylim_region)
axs[2].set_xlim(xlim_region)
axs[2].set_yticks(yticks_region)
axs[2].tick_params(axis="x", which="major", length=0)

axs[2].xaxis.set_major_locator(ticker.FixedLocator(xticks_region))
axs[2].xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x)}"))
axs[2].grid(True, which="major", axis="y", color="gray", linestyle='--')

# Add legend
fig.legend(loc="upper center", ncol=2, bbox_to_anchor=(0.5, 1.03), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_145.pdf", bbox_inches="tight")
