
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
streaming_services = ["Netflix", "Amazon Prime", "Disney+", "Hulu", "HBO Max", "Apple TV+"]
num_subscribers = [209, 175, 116, 43, 44, 33]  # in millions
avg_monthly_cost = [13.99, 8.99, 7.99, 11.99, 14.99, 4.99]  # in USD
hours_of_content = [50, 100, 30, 40, 70, 20]  # in thousands of hours
customer_satisfaction_rate = [85, 78, 90, 82, 88, 80]  # out of 100

x = np.arange(len(streaming_services))  # the label locations

labels = ["Number of Subscribers (M)", "Average Monthly Cost (USD)", "Hours of Content Available (K)", "Customer Satisfaction Rate"]
ylabel = "Metrics"
xlabel = "Streaming Services"
title = "Key Metrics of Different Streaming Services"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # the width of the bars
fig, ax = plt.subplots(figsize=(10, 6))

# Color scheme
colors = ["#4e79a7", "#f28e2b", "#e15759", "#76b7b2"]

# Plotting
rects1 = ax.bar(x - width * 1.5, num_subscribers, width, label=labels[0], color=colors[0])
rects2 = ax.bar(x - width / 2, avg_monthly_cost, width, label=labels[1], color=colors[1])
rects3 = ax.bar(x + width / 2, hours_of_content, width, label=labels[2], color=colors[2])
rects4 = ax.bar(x + width * 1.5, customer_satisfaction_rate, width, label=labels[3], color=colors[3])

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(streaming_services)
ax.legend()

# Additional Adjustments
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("bar_148.pdf", bbox_inches="tight")
