

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
tools = ["Westlaw", "LexisNexis", "Bloomberg Law", "Fastcase", "Casetext", "HeinOnline"]
ease_of_search = [4.5, 4.2, 3.8, 3.5, 4.0, 3.3]
quality_of_content = [4.7, 4.6, 4.2, 3.7, 4.3, 3.9]
update_frequency = [4.6, 4.8, 4.3, 3.8, 4.4, 4.0]
customer_support = [4.4, 4.3, 4.1, 3.6, 3.9, 3.7]

x = np.arange(len(tools))  # the label locations

labels = ["Ease of Search", "Quality of Content", "Update Frequency", "Customer Support"]
ylabel = "Ratings (1-5)"
xlabel = "Legal Research Tools"
title = "Ratings of Legal Research Tools on a Scale from 1-5"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # the width of the bars
fig, ax = plt.subplots(figsize=(10, 6))

# Plotting
rects1 = ax.bar(x - width * 1.5, ease_of_search, width, label=labels[0], color="#4e79a7", edgecolor="black")
rects2 = ax.bar(x - width / 2, quality_of_content, width, label=labels[1], color="#f28e2b", edgecolor="black")
rects3 = ax.bar(x + width / 2, update_frequency, width, label=labels[2], color="#e15759", edgecolor="black")
rects4 = ax.bar(x + width * 1.5, customer_support, width, label=labels[3], color="#76b7b2", edgecolor="black")

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(tools)
ax.legend()

# Enhance visualization
ax.grid(True, which='both', linestyle='--', linewidth=0.5)
ax.set_axisbelow(True)

# Adding rounded edges on the bars
for rect in [rects1, rects2, rects3, rects4]:
    for bar in rect:
        bar.set_linewidth(1.2)
        bar.set_edgecolor('black')
        bar.set_alpha(0.9)
        bar.set_capstyle('round')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_149.pdf", bbox_inches="tight")

