
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Philosophers Publication Data (number of works or citations)
philosophers = [
    "Plato",
    "Aristotle",
    "Kant",
    "Nietzsche",
    "Sartre",
    "Descartes",
    "Hegel",
    "Wittgenstein",
]
publications = [30, 40, 25, 18, 22, 15, 10, 35]

xlabel = "Philosophers"
ylabel = "Number of Publications"
title = "Publications of Famous Philosophers"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#8FBC8F",
    "#556B2F",
    "#6B8E23",
    "#8B4513",
    "#A0522D",
    "#CD853F",
    "#D2B48C",
    "#F4A460",
]
xticks = np.arange(len(philosophers))
ylim = [0, 45]

# Create figure and bar chart
fig, ax = plt.subplots(figsize=(10, 5))
bars = ax.bar(philosophers, publications, color=colors)

# Add publication values on top of the bars
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        yval,
        round(yval, 2),
        ha="center",
        va="bottom",
        fontsize=9
    )

# Set axis labels and title
ax.set_ylabel(ylabel)
ax.set_xticks(xticks)
ax.set_xticklabels(philosophers, rotation=45, ha="right")
ax.set_xlabel(xlabel)
ax.set_ylim(ylim)
ax.set_title(title, fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_152.pdf", bbox_inches="tight")
