
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
streaming_services = ["Netflix", "Amazon Prime", "Hulu", "Disney+", "Apple TV+", "HBO Max", "Peacock", "Paramount+"]
movies = [300, 250, 220, 0, 0, 0, 0, 0]
tv_shows = [0, 0, 0, 180, 100, 0, 0, 0]
documentaries = [0, 0, 0, 0, 0, 25, 20, 0]
animation = [0, 0, 0, 0, 0, 0, 0, 50]
labels = ["Movies", "TV Shows", "Documentaries", "Animation"]
xlabel = "Streaming Services"
ylabel = "Number of Titles"
title = "Content Distribution by Streaming Service"
ylim = [0, 400]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 6))

# Plotting
bar_width = 0.8
index = np.arange(len(streaming_services))

# Updated colors
colors = ["#1f77b4", "#aec7e8", "#ff7f0e", "#ffbb78"]

plt.bar(index, movies, bar_width, color=colors[0], label=labels[0])
plt.bar(index, tv_shows, bar_width, color=colors[1], label=labels[1], bottom=movies)
plt.bar(index, documentaries, bar_width, color=colors[2], label=labels[2], bottom=[i + j for i, j in zip(movies, tv_shows)])
plt.bar(index, animation, bar_width, color=colors[3], label=labels[3], bottom=[i + j + k for i, j, k in zip(movies, tv_shows, documentaries)])

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.title(title)
plt.xticks(index, streaming_services)
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_157.pdf", bbox_inches="tight")
