
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar charts
cities = ["City X", "City Y"]
pm25 = [0.25, 0.30]
pm10 = [0.20, 0.25]
no2 = [0.15, 0.10]
so2 = [0.10, 0.08]
o3 = [0.15, 0.17]
co = [0.15, 0.10]

# Calculating the y positions for the bars
y_pos = range(len(cities))

# Labels and axis information
labels = [
    "PM2.5",
    "PM10",
    "NO2",
    "SO2",
    "O3",
    "CO",
]
xlabel = "Percentage of Pollutants"
title = "Pollutant Distribution Across Cities"
legend_title = "Pollutant Types"
bar_width = 0.5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a specific size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 5))
# New color scheme
colors = ["#2E7D32", "#0288D1", "#FFD54F", "#FFA000", "#F4511E", "#B71C1C"]
# Stack the bars horizontally
ax.barh(y_pos, pm25, bar_width, color=colors[0], label=labels[0])
ax.barh(
    y_pos,
    pm10,
    bar_width,
    left=pm25,
    color=colors[1],
    label=labels[1],
)
ax.barh(
    y_pos,
    no2,
    bar_width,
    left=[i + j for i, j in zip(pm25, pm10)],
    color=colors[2],
    label=labels[2],
)
ax.barh(
    y_pos,
    so2,
    bar_width,
    left=[i + j + k for i, j, k in zip(pm25, pm10, no2)],
    color=colors[3],
    label=labels[3],
)
ax.barh(
    y_pos,
    o3,
    bar_width,
    left=[
        i + j + k + l
        for i, j, k, l in zip(
            pm25, pm10, no2, so2
        )
    ],
    color=colors[4],
    label=labels[4],
)
ax.barh(
    y_pos,
    co,
    bar_width,
    left=[
        i + j + k + l + m
        for i, j, k, l, m in zip(
            pm25, pm10, no2, so2, o3
        )
    ],
    color=colors[5],
    label=labels[5],
)

# Set the y-axis labels
ax.set_yticks(y_pos)
ax.set_yticklabels(cities)

# Set the x-axis label
ax.set_xlabel(xlabel)
ax.set_title(title)

# Add a legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.6), ncol=3, frameon=True, title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_159.pdf", bbox_inches="tight")
