
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar charts
categories = ["Electric Car", "Diesel Truck"]  # New Categories
fuel_efficiency = [0.85, 0.6]  # New Data
maintenance_cost = [0.05, 0.15]  # New Data
co2_emissions = [0.02, 0.2]  # New Data
speed = [0.03, 0.01]  # New Data
cargo_capacity = [0.03, 0.02]  # New Data
safety_index = [0.02, 0.02]  # New Data

y_pos = range(len(categories))
labels = [
    "Fuel Efficiency",
    "Maintenance Cost",
    "CO2 Emissions",
    "Speed",
    "Cargo Capacity",
    "Safety Index",
]
xlabel = "Transport Efficiency Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each segment (chosen a modern color palette)
colors = ["#4CAF50", "#FF5722", "#FFC107", "#03A9F4", "#9C27B0", "#E91E63"]
bar_width = 0.5
# Create a figure with a specific size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 3))

# Stack the bars horizontally
ax.barh(y_pos, fuel_efficiency, bar_width, color=colors[0], label=labels[0])
ax.barh(
    y_pos,
    maintenance_cost,
    bar_width,
    left=fuel_efficiency,
    color=colors[1],
    label=labels[1],
)
ax.barh(
    y_pos,
    co2_emissions,
    bar_width,
    left=[i + j for i, j in zip(fuel_efficiency, maintenance_cost)],
    color=colors[2],
    label=labels[2],
)
ax.barh(
    y_pos,
    speed,
    bar_width,
    left=[i + j + k for i, j, k in zip(fuel_efficiency, maintenance_cost, co2_emissions)],
    color=colors[3],
    label=labels[3],
)
ax.barh(
    y_pos,
    cargo_capacity,
    bar_width,
    left=[
        i + j + k + l
        for i, j, k, l in zip(
            fuel_efficiency, maintenance_cost, co2_emissions, speed
        )
    ],
    color=colors[4],
    label=labels[4],
)
ax.barh(
    y_pos,
    safety_index,
    bar_width,
    left=[
        i + j + k + l + m
        for i, j, k, l, m in zip(
            fuel_efficiency,
            maintenance_cost,
            co2_emissions,
            speed,
            cargo_capacity,
        )
    ],
    color=colors[5],
    label=labels[5],
)

# Set the y-axis labels
ax.set_yticks(y_pos)
ax.set_yticklabels(categories)

# Set the x-axis label
ax.set_xlabel(xlabel)

# Add a legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.5), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_160.pdf", bbox_inches="tight")

