

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar charts
categories = ["Energy Source A", "Energy Source B"]
production_cost = [0.35, 0.25]
maintenance_cost = [0.15, 0.1]
environmental_impact = [0.05, 0.08]
subsidies = [0.1, 0.07]
distribution_cost = [0.2, 0.15]
profit = [0.15, 0.35]

y_pos = range(len(categories))
labels = [
    "Production Cost",
    "Maintenance Cost",
    "Environmental Impact",
    "Subsidies",
    "Distribution Cost",
    "Profit",
]
xlabel = "Percentage of Total Allocation"

# Create a figure with a specific size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 4))

# Colors for each segment
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
bar_width = 0.5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stack the bars horizontally
ax.barh(y_pos, production_cost, bar_width, color=colors[0], label=labels[0])
ax.barh(
    y_pos,
    maintenance_cost,
    bar_width,
    left=production_cost,
    color=colors[1],
    label=labels[1],
)
ax.barh(
    y_pos,
    environmental_impact,
    bar_width,
    left=[i + j for i, j in zip(production_cost, maintenance_cost)],
    color=colors[2],
    label=labels[2],
)
ax.barh(
    y_pos,
    subsidies,
    bar_width,
    left=[i + j + k for i, j, k in zip(production_cost, maintenance_cost, environmental_impact)],
    color=colors[3],
    label=labels[3],
)
ax.barh(
    y_pos,
    distribution_cost,
    bar_width,
    left=[
        i + j + k + l
        for i, j, k, l in zip(production_cost, maintenance_cost, environmental_impact, subsidies)
    ],
    color=colors[4],
    label=labels[4],
)
ax.barh(
    y_pos,
    profit,
    bar_width,
    left=[
        i + j + k + l + m
        for i, j, k, l, m in zip(production_cost, maintenance_cost, environmental_impact, subsidies, distribution_cost)
    ],
    color=colors[5],
    label=labels[5],
)

# Set the y-axis labels
ax.set_yticks(y_pos)
ax.set_yticklabels(categories)

# Set the x-axis label
ax.set_xlabel(xlabel)

# Add a legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.3), ncol=3, frameon=False)

# Title
plt.title("Cost Distribution of Energy Sources")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_161.pdf", bbox_inches="tight")
