

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = ["2018", "2019", "2020"]
movie_a = [150, 180, 210]  # Box Office Revenue in Million USD
movie_b = [140, 160, 155]
movie_c = [130, 190, 250]

# X-axis positions
x = np.arange(len(years))

# Labels and Titles
labels = ["Movie A", "Movie B", "Movie C"]
ylabel = "Box Office Revenue (Million USD)"
xlabel = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
width = 0.2
ylim = [100, 300]

# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size
ax.bar(x - width, movie_a, width, label=labels[0], hatch="//", edgecolor="black", color="#99d8c9")
ax.bar(x, movie_b, width, label=labels[1], hatch="..", edgecolor="black", color="#fc9272")
ax.bar(x + width, movie_c, width, label=labels[2], hatch="xx", edgecolor="black", color="#9ecae1")

# Labels and Title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(years)
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_164.pdf", bbox_inches="tight")

