
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
categories = ["Football", "Basketball", "Baseball", "Soccer", "Tennis", "Hockey"]
performance_2021 = np.random.uniform(50, 100, size=len(categories))
performance_2022 = np.random.uniform(50, 100, size=len(categories))
performance_2023 = np.random.uniform(50, 100, size=len(categories))

x = np.arange(len(categories))  # the label locations

# Labels for legend
label_performance_2021 = "Performance 2021"
label_performance_2022 = "Performance 2022"
label_performance_2023 = "Performance 2023"

# Axis labels
xlabel = "Sports Categories"
ylabel = "Performance Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.25  # the width of the bars
# Axis ticks
xticks = x

fig, ax = plt.subplots(figsize=(12, 7))
rects1 = ax.bar(x - width, performance_2021, width, label=label_performance_2021, color="#1f77b4")
rects2 = ax.bar(x, performance_2022, width, label=label_performance_2022, color="#2ca02c")
rects3 = ax.bar(x + width, performance_2023, width, label=label_performance_2023, color="#ff7f0e")

ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticks(xticks)
ax.set_xticklabels(categories)
ax.set_title('Annual Performance by Sports Category')

# Adding gridlines for better readability
ax.grid(axis='y', linestyle='--', alpha=0.7)

# Customize tick parameters
ax.tick_params(axis="both", which="both", length=0, labelsize=12)

ax.legend(ncol=3, loc="upper center", bbox_to_anchor=(0.5, 1.1), frameon=False)

plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("bar_167.pdf", bbox_inches="tight")
