

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Privacy Law Reform",
    "Criminal Justice Reform",
    "Tax Law Reform",
    "Labor Law Reform",
    "Environmental Law Reform",
    "Corporate Law Reform",
][::-1]
support = [45.0, 55.0, 50.0, 60.0, 48.0, 52.0][::-1]
neutral = [35.0, 25.0, 30.0, 20.0, 32.0, 28.0][::-1]
oppose = [20.0, 20.0, 20.0, 20.0, 20.0, 20.0][::-1]

labels = ["Support", "Neutral", "Oppose"]

indices = range(len(categories))

# Chart labels
xticks = [0, 20, 40, 60, 80, 100]
xtickslabel = ["0", "20", "40", "60", "80", "100"]

xlabel = "Percentage (%)"
ylabel = "Legal Reform Comparisons"
title = "Public Opinion on Legal Reforms"
legendlabels = ["Support", "Neutral", "Oppose"]

bar_width = 0.6

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create stacked bar chart
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust figure size to 720x432 pixels

# Colors and styles
colors = ["#8ccf74", "#ffd966", "#d48a6b"]

bars1 = ax.barh(indices, support, bar_width, label=labels[0], color=colors[0])
bars2 = ax.barh(indices, neutral, bar_width, left=support, label=labels[1], color=colors[1])
bars3 = ax.barh(indices, oppose, bar_width, left=[i + j for i, j in zip(support, neutral)], label=labels[2], color=colors[2])

# Add text labels to the bars
for bars, color in zip([bars1, bars2, bars3], colors):
    for bar in bars:
        width = bar.get_width()
        center = bar.get_x() + width / 2
        ax.text(
            center,
            bar.get_y() + bar.get_height() / 2,
            f"{width:.1f}%",
            va="center",
            ha="center",
            color="black",
            fontsize=10,
        )

# Set the y-axis labels
ax.set_yticks(indices)
ax.set_yticklabels(categories, ha="right")

# Set the x-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xtickslabel)

# Add axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, pad=20, fontsize=14)

# Add legend
ax.legend(
    loc="upper center", bbox_to_anchor=(0.5, 1.05), shadow=True, ncol=3, frameon=False
)

# Remove spines
for spine in ["top", "right"]:
    ax.spines[spine].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_171.pdf", bbox_inches="tight")

