
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = ["Approval Rating", "Voter Turnout", "Policy Satisfaction"]
values = [45.0, 65.3, 55.1]

# Axes limits, labels, and ticks
xlabel = "Percentage"
title = "Key Political Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [0.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0]
xtickslabel = ["0%", "10%", "20%", "30%", "40%", "50%", "60%", "70%"]

# Create horizontal bar chart
plt.figure(figsize=(8, 4))  # Adjusting figure size for clarity
plt.barh(categories, values, color=['#2c7bb6', '#abd9e9', '#a6d96a'])

# Adding data labels
for index, value in enumerate(values):
    plt.text(value, index, f" {value}%", va="center", color="black")

# Adding title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel, fontsize=12)
# Apply the xticks and labels
plt.xticks(xticks, xtickslabel)

# Style adjustments
plt.tick_params(axis="both", which="both", length=0)
plt.grid(axis='x', linestyle='--', linewidth=0.7, color='gray')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_174.pdf", bbox_inches="tight")
