

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Ensuring reproducibility

# Data
steps = ["Concept", "Production", "Editing", "Distribution", "Feedback"]
audience_engagement_rate = [0.60, 0.65, 0.70, 0.68, 0.75]
content_quality_score = [0.70, 0.80, 0.85, 0.78, 0.82]
distribution_efficiency = [0.55, 0.60, 0.65, 0.63, 0.70]

# X-axis positions for each group of bars
x = np.arange(len(steps))

# Labels and titles
labels = [
    "Audience Engagement Rate",
    "Content Quality Score",
    "Distribution Efficiency",
]
title = "Media Content Development and Distribution Metrics"
xlabel = "Stages"
ylabel = "Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.25

yticks = np.arange(0, 1.1, 0.1)

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plotting bars
rects1 = ax.bar(
    x - bar_width,
    audience_engagement_rate,
    bar_width,
    label=labels[0],
    color="#1f77b4",
    edgecolor="white",
)
rects2 = ax.bar(
    x,
    content_quality_score,
    bar_width,
    label=labels[1],
    color="#ff7f0e",
    edgecolor="white",
)
rects3 = ax.bar(
    x + bar_width,
    distribution_efficiency,
    bar_width,
    label=labels[2],
    color="#2ca02c",
    edgecolor="white",
)

# Adding percentage labels on top of each bar
def add_labels(rects):
    for rect in rects:
        height = rect.get_height()
        ax.annotate(
            f"{height*100:.1f}%",
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(rects1)
add_labels(rects2)
add_labels(rects3)

# Title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# X and Y ticks
ax.set_xticks(x)
ax.set_xticklabels(steps)
ax.set_yticks(yticks)

# Legend
ax.legend(loc="upper center", ncol=3, frameon=False)

# Grid lines
ax.yaxis.grid(True)
ax.set_axisbelow(True)

grid_color = "#bdbdbd"
# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)

# hidden ticks
plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_179.pdf", bbox_inches="tight")

