
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
categories = [
    "Wheat",
    "Rice",
    "Maize",
    "Barley",
    "Oats",
    "Soybeans",
    "Sunflowers",
    "Potatoes",
    "Tomatoes",
    "Apples",
    "Oranges",
    "Bananas",
    "Grapes",
    "Strawberries",
    "Carrots",
    "Broccoli",
    "Peppers",
    "Cabbage",
    "Spinach",
    "Lettuce",
    "Onions",
    "Avg",
]
# Generate three lists
Cereal_Yield, Fruit_Yield, Vegetable_Yield = np.random.dirichlet(np.ones(3), size=len(categories)).T

Cereal_Yield = Cereal_Yield * 100
Fruit_Yield = Fruit_Yield * 100
Vegetable_Yield = Vegetable_Yield * 100

r = np.arange(len(categories))
labels = ["Cereal Yield", "Fruit Yield", "Vegetable Yield"]

# Axis Labels and Title
xlabel = "Crop Types"
ylabel = "Yield Percentage (%)"
title = "Agricultural Production Yields by Crop Type"
legend_labels = ["Cereal Yield", "Fruit Yield", "Vegetable Yield"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.9
# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(
    r,
    Cereal_Yield,
    color="#76c893",
    edgecolor="black",
    hatch="\\\\\\",
    width=bar_width,
    label=labels[0],
)
bar2 = ax.bar(
    r,
    Fruit_Yield,
    bottom=Cereal_Yield,
    color="#ffd700",
    edgecolor="black",
    hatch="--",
    width=bar_width,
    label=labels[1],
)
bar3 = ax.bar(
    r,
    Vegetable_Yield,
    bottom=Cereal_Yield + Fruit_Yield,
    color="#1f77b4",
    edgecolor="black",
    hatch="++",
    width=bar_width,
    label=labels[2],
)

# Labels, title and legend
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=-45, ha="left", fontsize=10)
ax.set_yticks(np.arange(0, 101, 20))
ax.set_ylim(0, 100)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.legend(labels=legend_labels, loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3, fontsize=10)

# Grid lines
ax.yaxis.grid(True, linestyle="--")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_180.pdf", bbox_inches="tight")
