
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Social Media Data
countries = [
    "USA", "China", "India", "Brazil", "Russia", "Japan", 
    "Germany", "UK", "France", "Italy", "Canada", 
    "South Korea", "Australia", "Spain", "Mexico", 
    "Indonesia", "Turkey", "Netherlands", "Saudi Arabia", "Switzerland"
]
# Generate three lists representing user engagement rate, advertising reach, and content shares
UserEngagement, AdReach, ContentShares = np.random.dirichlet(np.ones(3), size=len(countries)).T

# Convert to percentage
UserEngagement = UserEngagement * 100
AdReach = AdReach * 100
ContentShares = ContentShares * 100

# Indices
r = np.arange(len(countries))
# Labels and other text
xlabel = 'Countries'
ylabel = 'Metrics (%)'
title = 'Social Media Metrics by Country'
legend_labels = ["User Engagement Rate", "Advertising Reach", "Content Shares"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.85
# Plot
fig, ax = plt.subplots(figsize=(12, 6))
bar1 = ax.bar(
    r,
    UserEngagement,
    color="#66c2a5",
    edgecolor="black",
    hatch="///",
    width=bar_width,
    label=legend_labels[0],
)
bar2 = ax.bar(
    r,
    AdReach,
    bottom=UserEngagement,
    color="#fc8d62",
    edgecolor="black",
    hatch="\\\\\\",
    width=bar_width,
    label=legend_labels[1],
)
bar3 = ax.bar(
    r,
    ContentShares,
    bottom=UserEngagement + AdReach,
    color="#8da0cb",
    edgecolor="black",
    hatch="--",
    width=bar_width,
    label=legend_labels[2],
)

# Labels, title and legend
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')

ax.set_xticks(r)
ax.set_xticklabels(countries, rotation=-45, ha="center")
ax.set_yticks(np.arange(0, 101, 20))
ax.set_ylim(0, 100)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Grid lines
ax.yaxis.grid(True, linestyle="--")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_181.pdf", bbox_inches="tight")
