
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)

# Data
categories = [
    "Christianity",
    "Islam",
    "Hinduism",
    "Buddhism",
    "Sikhism",
    "Judaism",
    "Bahá'í Faith",
    "Jainism",
    "Shinto",
    "Taoism",
    "Zoroastrianism",
    "Confucianism",
    "Druze",
    "Tenrikyo",
    "Wicca",
    "Cao Dai",
    "Ancestral Worship",
    "Spiritualism",
    "Unitarian",
    "Rastafarianism",
]

# Generate three lists
Adherents, ReligiousTexts, PlacesOfWorship = np.random.dirichlet(np.ones(3), size=len(categories)).T

Adherents = Adherents * 100
ReligiousTexts = ReligiousTexts * 100
PlacesOfWorship = PlacesOfWorship * 100

r = np.arange(len(categories))
labels = ["Adherents", "Religious Texts", "Places of Worship"]

# Chart Labels
xlabel = 'Religions'
ylabel = 'Distribution (%)'
title = 'Religious Data Distribution'
legendlabels = ["Adherents", "Religious Texts", "Places of Worship"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.9

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(r, Adherents, color="#ff9999", edgecolor="#ff4d4d", hatch='//', width=bar_width, label=labels[0])
bar2 = ax.bar(r, ReligiousTexts, bottom=Adherents, color="#66b3ff", edgecolor="#3399ff", hatch='xx', width=bar_width, label=labels[1])
bar3 = ax.bar(r, PlacesOfWorship, bottom=Adherents + ReligiousTexts, color="#99ff99", edgecolor="#33cc33", hatch='..', width=bar_width, label=labels[2])

# Labels, title and legend
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=-45, ha="center")
ax.set_yticks(np.arange(0, 101, 20))
ax.set_ylim(0, 100)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Grid lines
ax.yaxis.grid(True, linestyle="--")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_182.pdf", bbox_inches="tight")
