

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(3)
# New Data representing average population (in millions)
regions = ["North", "South", "East", "West", "Central"]
population_2020 = [5.1, 4.5, 6.2, 3.8, 5.9]
population_2023 = [5.4, 4.8, 6.5, 4.0, 6.3]

# Labels for legend and plot type
labels = regions
# Limits, labels, and title for the plot
ylim_values = (3.0, 7.0)
ylabel_value = "Average Population (millions)"
xticks_values = [6, 12]
xtickslabel_values = ["Year 2020", "Year 2023"]

# Bar width
bar_width = 1
# X-axis positions
r1 = np.arange(len(regions))
r2 = [x + bar_width + len(r1) for x in r1]

# Titles and labels
title_text = "Comparison of Average Population by Region"
supertitle_text = "Regional Population Statistics"
xlabel_value = "Years"
legend_labels = regions
annotation_texts_2020 = [str(p) for p in population_2020]
annotation_texts_2023 = [str(p) for p in population_2023]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))
# Colors (reflecting agriculture)
colors = ["#8FBC8F", "#DEB887", "#4682B4", "#9ACD32", "#556B2F"]

# Create bars for Year 2020
for i in range(len(r1)):
    plt.bar(
        xticks_values[0] + (i - 2) * bar_width,
        population_2020[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=labels[i] if xticks_values[0] == 6 else "",
    )

# Create bars for Year 2023
for i in range(len(r2)):
    plt.bar(
        xticks_values[1] + (i - 2) * bar_width,
        population_2023[i],
        color=colors[i],
        width=bar_width,
        edgecolor="white",
    )

# Add text on top of the bars (Year 2020)
for i in range(len(r1)):
    plt.text(
        xticks_values[0] + (i - 2) * bar_width,
        population_2020[i] + 0.05,
        str(population_2020[i]),
        ha="center",
    )
    
# Add text on top of the bars (Year 2023)
for i in range(len(r2)):
    plt.text(
        xticks_values[1] + (i - 2) * bar_width,
        population_2023[i] + 0.05,
        str(population_2023[i]),
        ha="center",
    )

# General layout
plt.xticks(xticks_values, xtickslabel_values)
plt.ylabel(ylabel_value)
plt.ylim(*ylim_values)
plt.legend(loc="upper center", ncol=5, bbox_to_anchor=(0.5, 1.15), frameon=False)
plt.title(title_text)
plt.suptitle(supertitle_text)
plt.xlabel(xlabel_value)

plt.tick_params(axis="x", which="both", length=0)
plt.gca().yaxis.grid(True)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_185.pdf", bbox_inches="tight")
