

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
regions = [1, 2]  # Represents Urban and Rural areas
math_scores = [85, 75]  # Average Math Scores
science_scores = [90, 70]  # Average Science Scores
benchmark_score = 80  # Benchmark score for comparison

labels = ["Average Math Scores", "Average Science Scores"]
xlabel = "Regions"
ylabel = "Average Scores"
title = "Student Performance in Various Regions"
axlabels = "Benchmark Score"

ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(8, 6)
)
bar_width = 0.35
index = np.arange(len(regions))

bar1 = ax.bar(index, math_scores, bar_width, label=labels[0], color="#4CAF50")
bar2 = ax.bar(
    index + bar_width, science_scores, bar_width, label=labels[1], color="#2196F3"
)

# Adding the text on the bars
for rect in bar1 + bar2:
    height = rect.get_height()
    ax.text(
        rect.get_x() + rect.get_width() / 2.0,
        height,
        "%.2f" % height,
        ha="center",
        va="bottom",
    )

# Benchmark Line
ax.axhline(y=benchmark_score, color="red", linestyle="--", label=axlabels)

# Labels, title and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_ylim(ylim)
ax.set_xticks(index + bar_width / 2)
ax.set_xticklabels(['Urban', 'Rural'])
ax.legend(loc="upper right")
grid_color = "#d2d2d2"
ax.yaxis.grid(True, linestyle='--', linewidth=0.7)
ax.set_axisbelow(True)

# Set border color
for spine in ax.spines.values():
    spine.set_edgecolor(grid_color)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("bar_186.pdf", bbox_inches="tight")

