
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(1)

# Data for history domain
historical_periods = [
    "Ancient Egypt", "Roman Empire", "Middle Ages", "Renaissance", "Industrial Revolution", "Modern Era"
]
cultural_significance = [95, 80, 85, 90, 75, 70]
technological_advancement = [70, 85, 60, 80, 95, 90]
influence_on_society = [85, 90, 75, 70, 85, 80]
historical_events_number = [100, 110, 60, 75, 90, 85]

# Bar positions
x = np.arange(len(historical_periods))
labels = [
    "Cultural Significance",
    "Technological Advancement",
    "Influence on Society",
    "Historical Events (in dozens)",
]
xlabel = "Historical Periods"
ylabel = "Metrics"
title = "Historical Period Analysis"
ylim = [0, 120]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.2  # Adjusted width for spacing
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted to a larger dimension

ax.bar(x - width * 1.5, cultural_significance, width, label=labels[0], color="#FFB6C1")
ax.bar(x - width / 2, technological_advancement, width, label=labels[1], color="#ADD8E6")
ax.bar(x + width / 2, influence_on_society, width, label=labels[2], color="#90EE90")
ax.bar(x + width * 1.5, historical_events_number, width, label=labels[3], color="#FFD700")

# Labels and Title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(historical_periods)
ax.set_ylim(ylim)

# Legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_192.pdf", bbox_inches="tight")
