

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data preparation
continents = ["Asia", "Europe", "Africa", "North America", "South America", "Australia"]
average_temperature = [30, 20, 25, 15, 28, 22]
average_rainfall = [100, 70, 120, 80, 95, 90]
average_humidity = [60, 50, 65, 55, 62, 58]
average_wind_speed = [10, 12, 9, 14, 11, 13]

# Bar positions
x = np.arange(len(continents))
labels = [
    "Average Temperature (°C)",
    "Average Rainfall (mm)",
    "Average Humidity (%)",
    "Average Wind Speed (km/h)",
]
ylabel = "Geographical Data"
title = "Continental Average Geographical Data"
xlabel = "Continents"
ylim = [0, 130]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.15  # Width of the bars
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size

# Plot bars for each category
ax.bar(x - width * 1.5, average_temperature, width, label=labels[0], color="#66c2a5")
ax.bar(x - width * 0.5, average_rainfall, width, label=labels[1], color="#fc8d62")
ax.bar(x + width * 0.5, average_humidity, width, label=labels[2], color="#8da0cb")
ax.bar(x + width * 1.5, average_wind_speed, width, label=labels[3], hatch="//", color="#e78ac3")

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(continents)
ax.set_ylim(ylim)  # Adjusted y-axis limit

# Move legend inside the plot area
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_193.pdf", bbox_inches="tight")

