
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["0-18", "19-35", "36-50", "51-65", "66+"][::-1]
region1_counts = [25000, 40000, 30000, 15000, 5000][::-1]
region2_counts = [30000, 45000, 35000, 20000, 7000][::-1]
region3_counts = [20000, 35000, 32000, 18000, 8000][::-1]

labels = ["Region 1", "Region 2", "Region 3"]
y_pos = range(len(categories))

xlabel = "Population Count"
ylabel = "Age Groups"
title = "Population Distribution by Age Group and Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))

ax.barh(y_pos, region1_counts, bar_width, color="#ffcc5c", label=labels[0])
ax.barh(y_pos, region2_counts, bar_width, left=region1_counts, color="#96ceb4", label=labels[1])
ax.barh(y_pos, region3_counts, bar_width, left=[i + j for i, j in zip(region1_counts, region2_counts)], color="#6b5b95", label=labels[2])

# Adding the numerical values within each segment
for i in range(len(categories)):
    ax.text(region1_counts[i] / 2, i, str(region1_counts[i]), ha="center", va="center", color="black")
    ax.text(region1_counts[i] + region2_counts[i] / 2, i, str(region2_counts[i]), ha="center", va="center", color="black")
    ax.text(region1_counts[i] + region2_counts[i] + region3_counts[i] / 2, i, str(region3_counts[i]), ha="center", va="center", color="black")

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_yticks(y_pos)
ax.set_yticklabels(categories)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_197.pdf", bbox_inches="tight")
