
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "Color Harmony",
    "Typography",
    "Visual Hierarchy",
    "Whitespace",
    "Consistency",
    "Imagery Quality",
    "Responsiveness",
    "Contrast",
    "Alignment",
    "Proximity",
    "Balance",
    "Repetition",
    "Movement",
    "Texture",
    "Scale",
    "Rhythm",
    "Emphasis",
    "Unity"
]
differences = [
    25,
    -10,
    35,
    -15,
    5,
    20,
    -5,
    30,
    -20,
    40,
    -30,
    10,
    -25,
    15,
    -35,
    50,
    -40,
    45,
]

title = "Relative Difference in AI vs. Human Focus on Graphic Design Elements"
xlabel = "Difference (%)"
ylabel = "Design Element"
xlim = [-50, 60]
xticks = range(-50, 61, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8c564b" if x < 0 else "#2ca02c" for x in differences]
# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 5))
bars = ax.barh(categories, differences, color=colors)

# Highlight specific bars with patterns for emphasis
for bar in bars:
    if bar.get_width() > 0:
        bar.set_hatch('//')

# Set title and labels
ax.set_title(title, fontsize=14, weight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True, linestyle='--', alpha=0.7)

# Improve overall layout and readability
plt.gca().invert_yaxis()  # Invert y-axis to have the highest values on top

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_198.pdf", bbox_inches="tight")
