
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Email Open Rate",
    "Click-Through Rate",
    "Response Time",
    "Customer Satisfaction",
    "Net Promoter Score",
    "Lead Conversion Rate",
    "Customer Retention Rate",
    "Churn Rate",
    "Social Media Engagement",
    "Marketing ROI",
    "Content Share Rate",
    "Ad Spend Efficiency",
    "Website Bounce Rate",
    "Average Session Duration",
    "New Leads",
    "Returning Visitors",
    "Customer Lifetime Value",
    "Sales Revenue Per Lead",
]
differences = [
    5,
    10,
    -7,
    15,
    -10,
    8,
    12,
    -20,
    18,
    -5,
    7,
    -12,
    9,
    6,
    14,
    -8,
    20,
    25,
]

title = "Relative Differences in Communication Metrics"
xlabel = "Difference (%)"
ylabel = "Communication Metric"
xlim = [-25, 30]
xticks = range(-25, 31, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff6f61" if x < 0 else "#6baed6" for x in differences]  # Red for negative, Blue for positive
hatches = ["//" if x < 0 else "" for x in differences]  # Hatching for negative bars

# Create figure and plot
fig, ax = plt.subplots(figsize=(12, 7))
bars = ax.barh(categories, differences, color=colors)

# Apply hatches to negative bars
for bar, hatch in zip(bars, hatches):
    bar.set_hatch(hatch)

# Set title and labels
ax.set_title(title, fontsize=16, weight='bold')
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True)

# Annotate significant bars
for bar in bars:
    width = bar.get_width()
    label_x_pos = width if width < 0 else width
    ax.text(label_x_pos, bar.get_y() + bar.get_height()/2, f'{width}%', va='center', ha='left' if width < 0 else 'right', fontsize=12, color='black')

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_199.pdf", bbox_inches="tight")
